﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.ValidationDataService.Data;
using VA.PPMS.IWS.ValidationDataService.Interface;

namespace VA.PPMS.IWS.ValidationDataService
{
    public class ValidationDataService : IValidationDataService
    {
        private readonly ILog _logger;
        private readonly NppesData _nppesData;

        public ValidationDataService(ILog logger, NppesData nppesData)
        {
            _logger = logger;
            _nppesData = nppesData;

        }

        public async Task ProcessData()
        {
            _logger.Info($"@@@@ INFO - Start ValidationDataService @@@@");

            await _nppesData.ProcessCurrentData();

            _logger.Info($"@@@@ INFO - End ValidationDataService @@@@");
        }
    }
}